﻿using System;

class Pierwiastek
{
  public static void Main(string[] args)
  {
    double parametrA, parametrB, parametrC;

    if(args.Length < 3)
    {
      Console.WriteLine(
        "Wywołanie programu: pierwiastek.exe parametrA parametrB parametrC");
      return;
    }

    try
    {
      parametrA = Double.Parse(args[0]);
      parametrB = Double.Parse(args[1]);
      parametrC = Double.Parse(args[2]);
    }
    catch(Exception)
    {
      Console.WriteLine(
        "Jeden z parametrów równania nie jest poprawną liczbą!");
      return;
    }

    Console.WriteLine("Wprowadzone parametry równania:\n");
    Console.WriteLine("A: " + parametrA + " B: " + parametrB + 
                      " C: " + parametrC + "\n");

    if (parametrA == 0)
    {
      Console.WriteLine("To nie jest równanie kwadratowe: A = 0!");
    }
    else
    {
      double delta = parametrB * parametrB - 4 * parametrA * parametrC;
      double wynik;

      if (delta < 0)
      {
        Console.WriteLine("Delta < 0.");
        Console.WriteLine(
          "Brak rozwiązań w zbiorze liczb rzeczywistych.");
      }
      else if (delta == 0)
      {
        wynik = -parametrB / (2 * parametrA);
        Console.WriteLine("Rozwiązanie: x = " + wynik);
      }
      else
      {
         wynik = (-parametrB + Math.Sqrt(delta)) / (2 * parametrA);
         Console.Write("Rozwiązanie: x1 = " + wynik);
         wynik = (-parametrB - Math.Sqrt(delta)) / (2 * parametrA);
         Console.WriteLine(", x2 = " + wynik);
      }
    }
  }
}
